/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (06/06/07)
 */    
package com.ejie.p06b.util.xml;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.xml.P06BMediadorGenerateXML;


/**
 * Esta clase representa un conjunto de mtodos para utilidades varias de uso
 * de XML.
 */
public class P06BUtilXML {
	
	public static void main(String[] args){
		try {
				String xml="";
		
				xml = P06BMediadorGenerateXML.execute();
				
				P06BUtilXML.validateStr(xml,"C:\\datos\\p06b\\file\\xsd\\PUI.xsd");
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public static boolean validateUTF8(String fileXml,String fileXsl) throws P06BException, ParserConfigurationException, SAXException, IOException{
		//validacin de que el xml cumple el esquema
        try {
        	
        	FileInputStream fin=new FileInputStream(fileXml);
        	int dato;
        	ByteArrayOutputStream fin2=new ByteArrayOutputStream();
            while (-1!=(dato=fin.read())){
            	fin2.write(dato);
            }
            byte[] fileXMLInBytes = fin2.toByteArray();
            boolean isValidXml = P06BXmlValidator.validateXmlUtf8TextUsingXsdFile(fileXMLInBytes,fileXsl); 
            if (!isValidXml) {
            	return false;
            }
        } catch (Exception e) { 
            System.out.println("EXCEPCION:"+e.getMessage());
        }
        // FIN validacin del esquema 
        return true;
	}
	
	public static boolean validate(String fileXml,String fileXsl) throws P06BException, ParserConfigurationException, SAXException, IOException{
		//validacin de que el xml cumple el esquema
        try {
            boolean isValidXml = P06BXmlValidator.validateXmlFileUsingXsdFile(fileXml,fileXsl); 
            if (!isValidXml) {
            	return false;
            }
        } catch (Exception e) { 
            System.out.println("EXCEPCION:"+e.getMessage());
        }
        // FIN validacin del esquema 
        return true;
	}
	
	public static boolean validateStr(String strXml,String fileXsl) throws P06BException, ParserConfigurationException, SAXException, IOException{
		//validacin de que el xml cumple el esquema
        try {
            boolean isValidXml = P06BXmlValidator.validateXmlStringTextUsingXsdFile(strXml,fileXsl); 
            if (!isValidXml) {
            	return false;
            }
        } catch (Exception e) { 
            System.out.println("EXCEPCION:"+e.getMessage());
        }
        // FIN validacin del esquema 
        return true;
	}
}	